
//
// The server only runs this file so it can send it to the client
//

if ( SERVER ) then AddCSLuaFile( "utilities_menu2.lua" ) return end


local function Undo( CPanel )
	CPanel:AddControl( "Header", { Text = "#Undo" }  )
end

local function User_Cleanup( CPanel )
	CPanel:AddControl( "Header", { Text = "#Cleanup" }  )
end

local function ServerSettings( CPanel )

	CPanel:AddControl( "Header", { Text = "#Server Settings" }  )
		
	CPanel:AddControl( "TextBox", 	{ Label = "#Server Password",			Command = "sv_password", 	WaitForEnter =	"1" }  )	
	
	CPanel:AddControl( "Button", 	{ Label = "#Enable/Disable AI",			Command = "ai_disable", 	Text = "Toggle" }  )	
	
	CPanel:AddControl( "CheckBox", 	{ Label = "#Allow NPCs",				Command = "sbox_allownpcs" }  )	
	CPanel:AddControl( "CheckBox", 	{ Label = "#Allow Flying (Noclip)",		Command = "sbox_noclip" }  )	
	CPanel:AddControl( "CheckBox", 	{ Label = "#God Mode",					Command = "sbox_godmode" }  )	
	CPanel:AddControl( "CheckBox", 	{ Label = "#Disable PvP Damage",		Command = "sbox_playergod" }  )	
	
	CPanel:AddControl( "Slider", 	{ Label = "#Gravity", Type = "Float", 	Command = "sv_gravity", 	Min = "-200", 	Max = "600" }  )
	CPanel:AddControl( "Slider", 	{ Label = "#Physics Timescale",	Type = "Float", 	Command = "phys_timescale", 	Min = "0", 	Max = "2" }  )
	CPanel:AddControl( "Slider", 	{ Label = "#Physics Iterations", Type = "Integer", 	Command = "gmod_physiterations", 	Min = "1", 	Max = "10" }  )
	
end


local function Matrix( CPanel )

	CPanel:AddControl( "Header", { Text = "#Matrix Mod" }  )

	CPanel:AddControl( "CheckBox",	{Label = "Cheats",				Command = "sv_cheats",  }  )
	CPanel:AddControl( "Button",	{Label = "Bindings",			Command = "exec MatrixMode",	Text = "Binds alt and o" }  )
	CPanel:AddControl( "Button",	{Label = "Manual Button",			Command = "host_timescale 0.150;sv_gravity 350;phys_pushscale 500;cl_phys_timescale 0.150;play slowdown.wav;",	Text = "SLOMO" }  )
	CPanel:AddControl( "Button",	{Label = "Manual Button 2",			Command = "host_timescale 1;sv_gravity 600;phys_pushscale 1;cl_phys_timescale 1;play speedup.wav;",	Text = "Regular time" }  )

end


	
/*
// Tool Menu
*/
local function PopulateUtilityMenus()

	spawnmenu.AddToolMenuOption( "Utilities", "User", 	"User_Cleanup",	"#Cleanup", 	"", 	"", 	User_Cleanup )
	spawnmenu.AddToolMenuOption( "Utilities", "User", 	"Undo", 	"#Undo", 			"", 	"", 	Undo )
	
	spawnmenu.AddToolMenuOption( "Utilities", "Admin", 	"Admin_Cleanup", 	"#Cleanup", 	"", 	"", 	User_Cleanup )
	spawnmenu.AddToolMenuOption( "Utilities", "Admin", 	"ServerSettings", 	"#Settings", 	"", 	"", 	ServerSettings )
	spawnmenu.AddToolMenuOption( "Utilities", "Admin", 	"Matrix", 	"#MatrixMod", 		"", 	"", 	Matrix )
	

end

hook.Add( "PopulateToolMenu", "PopulateUtilityMenus", PopulateUtilityMenus )

/* 
// Categories
*/
local function CreateUtilitiesCategories()

	spawnmenu.AddToolCategory( "Utilities", 	"User", 	"#User" )
	spawnmenu.AddToolCategory( "Utilities", 	"Admin", 	"#Admin" )

end	

hook.Add( "AddToolMenuCategories", "CreateUtilitiesCategories", CreateUtilitiesCategories )